package net.w_horse.excelpojo.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import net.w_horse.excelpojo.xml.tag.DataDirection;
import net.w_horse.excelpojo.xml.tag.RetrieveFrom;
import net.w_horse.excelpojo.xml.tag.Use;


@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface MappedCell {
	String previousLabel() default "";
	String position() default "";
	RetrieveFrom retrieveFrom() default RetrieveFrom.BOTTOM;
	DataDirection dataDirection() default DataDirection.RIGHT;
	int margedLabel() default 0;
	Use use() default Use.NONE;
	String range() default "";
}
